// File created: 2007-10-04 13:56:20

package ope.adventure;

public final class Adventure {
	private final Configuration config = new Configuration();
	private final Player        player = new Player(Room.getStartingRoom());

	// required by UI
	public String getName() {
		return "Mag-1.3581: Advanced Summoning in Practice (10 cr)";
	}

	// required by UI
	public String playTurn(final String command) {

		if (player.getTime() >= Player.MAX_TIME) {
			player.endGame();
			return
				"An utterly bored assistant barges in and declares you have " +
				"failed, taking far\ntoo many years to complete the assignment.";
		} else if (
			(config.hasBooks () || Action.doableWithoutBooks (command)) &&
			(config.hasSpells() || Action.doableWithoutSpells(command))
		)
			player.setTime(Action.perform(command, config, player));
		else
			Action.haveNoData();

		return Action.getOutput().trim();
	}

	// required by UI
	public boolean isOver() { return player.hasFinished() || player.hasQuit(); }

	// required by UI
	public String getWelcome() {
		return
			"You step into the lobby, a place you know well. For the past six " +
			"months, you've\nbeen spending most of your time here, mostly " +
			"doing exercises in the library." +
			"\n\n" +
			"Now it's the time for all that to come to an end." +
			"\n\n" +
			"You've done all the necessary assignments for this course, " +
			"Advanced Summoning in\nPractice (you can't remember the course " +
			"code), except for one. The task is to\nuse everything you've " +
			"learned so far to summon an otherworldly entity." +
			"\n\n" +
			"Unfortunately, you haven't studied very much and have pretty much " +
			"no idea what\nyou're doing. Fortunately, you've got plenty of time." +
			"\n\n" +
			"This is the last course you need to pass for your degree, and " +
			"you've already got\na career in spellcraft waiting for you, so " +
			"you've steeled yourself to get the\nassignment done properly and " +
			"right now, much as it is against your usual way of\ndoing things." +
			"\n\n" +
			"You might want to start by reviewing the assignment before going " +
			"to the library\nto study and practice." +
			"\n\n" +
			"[If it's your first time playing, read 'help'.]";
	}

	// required by UI
	public String getGoodbye() {
		return
			"You completed the game in --- " +player.getTime()+ " --- turns." +
			"\n==========================\n" +
			"The game has ended: hopefully it was to your satisfaction. There " +
			"are many\nendings: if you enjoyed the game and would like " +
			"something more, keep playing!";
	}

	// both required by UI
	public Player getPlayer()    { return player; }
	public int    getTurnCount() { return player.getTime(); }
}
