// File created: 2007-10-04 13:56:20

package ope.adventure;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import ope.adventure.book.Book;
import ope.adventure.book.BookSection;

public final class Player {
	private             boolean           hasQuit  = false;
	private             boolean           hasEnded = false;
// SAN	public static final byte              MAX_SANITY = 99;
// SAN	private             byte              sanity     = MAX_SANITY;
	private             Room              location;
	private       final Deque<Book>       bookStack  = new ArrayDeque<Book>();
	private             int               time = 0;
	public static final int               MAX_TIME = 1 << 30;
	private             List<Book>        prevBooks;
	private             List<BookSection> prevSections;
	private             List<String>      prevSnippets;

	private final Map<String, String>
		memorizations = new HashMap<String, String>();

	public Player(final Room start) {
		location = start;
	}

	// required by UI
	public boolean hasQuit() { return hasQuit; }
	public void       quit() { hasQuit = true; }

	public boolean hasFinished() { return hasEnded; }
	public void        endGame() { hasEnded = true; }
	public void  cancelEndGame() { hasEnded = false; }

	// required by UI
	public Area getLocation() {
		return isReading() ? topBook() : getRoom();
	}

	public int  getTime()            { return time; }
	public void setTime(final int t) { time = t; }

	public Room getRoom()             { return location; }
	public void setRoom(final Room r) { location = r; }

	public Book    topBook()   { return  bookStack.peekFirst(); }
	public Book    popBook()   { return  bookStack.pop(); }
	public boolean isReading() { return !bookStack.isEmpty(); }
	public int     bookCount() { return  bookStack.size(); }

	public void startReading  (final Book book) {
		bookStack.push(book);
	}
	public boolean stopReading(final Book book) {
		return bookStack.remove(book);
	}
	public boolean isReading  (final Book book) {
		return bookStack.contains(book);
	}
	public Iterator<Book> bookStackIterator() {
		return bookStack.descendingIterator();
	}

	public List<Book>        getPrevBooks()    { return prevBooks; }
	public List<BookSection> getPrevSections() { return prevSections; }
	public List<String>      getPrevSnippets() { return prevSnippets; }

	public void setNextBooks(final List<Book> l) {
		prevBooks = l;
	}
	public void setNextSections(final List<BookSection> l) {
		prevSections = l;
	}
	public void setNextSnippets(final List<String> l) {
		prevSnippets = l;
	}

// SAN	public void modifySanity(final byte san) {
// SAN		sanity += san;
// SAN		if (sanity > MAX_SANITY)
// SAN			sanity = MAX_SANITY;
// SAN	}

	public void memorize(final String spell, final String as) {
		memorizations.put(as, spell);
	}
	public String getSpell(final String spell) {
		final String memorizedAs = memorizations.get(spell);
		return memorizedAs != null ? memorizedAs : spell;
	}
}
