// File created: 2007-10-21 20:05:38

package ope.adventure.actions;

import java.util.List;

import ope.adventure.Action;
import ope.adventure.Configuration;
import ope.adventure.Player;
import ope.adventure.book.Book;
import ope.adventure.book.ID;

// "recent"
public final class RecentAction extends Action {
	public boolean doableWithoutBooks () { return true; }
	public boolean doableWithoutSpells() { return true; }
	public boolean stopReading        () { return false; }

	public String getShortHelp() {
		return "display recent books and sections";
	}
	public String getLongHelp() {
		return
			"\"recent\"\n" +
			"\n" +
			"Displays the most recently displayed lists of book identifiers and " +
			"section\nidentifiers. These are the valid identifiers for commands " +
			"such as \"read\"\nor \"browse\".";
	}

	public int perform(
		final List<String> words,
		final Configuration conf, final Player player
	) {
		ignoringExcess(words, 0);

		final List<Book> books = player.getPrevBooks();

		if (books == null || books.isEmpty())
			println("You haven't looked at any books recently.");
		else {
			println("Your recent books list:");
			ID.resetBookId();
			for (final Book book : books)
				printBookId(book);
		}

		final List<String> snippets = player.getPrevSnippets();

		if (snippets == null || snippets.isEmpty())
			println("You haven't looked at the contents of any book recently.");
		else {
			println("Your recent sections list:");
			ID.resetSectionId();
			for (final String snippet : snippets)
				printSectionId(snippet);
		}

		return 0;
	}
}
