// File created: 2007-10-19 17:08:04

package ope.adventure.book;

import java.util.HashMap;
import java.util.Map;

public final class BookSection {
	private final String contents;
	// maps keywords to snippets
	private final Map<String, String> snippets = new HashMap<String, String>();

	public BookSection(final String c) {
		contents = c;
	}

	public String getContents() { return contents; }

	public String getSnippet(final String kw) {
		return snippets.get(kw);
	}
	public boolean addSnippet(final String snippet, final String kw) {
		if (snippets.containsKey(kw))
			return false;
		else {
			snippets.put(kw, snippet);
			return true;
		}
	}
}
