// File created: 2007-10-06 16:57:56

package ope.adventure.book;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class Library implements Iterable<Book> {

	// maps a keyword to a list of books in which it appears
	private final Map<String, List<Book>>
		byKeyword = new HashMap<String, List<Book>>();

	private final Map<String, Book>
		byTitle   = new HashMap<String, Book>();

	private final List<Book> books = new ArrayList<Book>();

	public Book getBook(final String name) {
		return byTitle.get(name);
	}
	public List<Book> getByKeyword(final String kw) {
		return byKeyword.get(kw);
	}

	public void addBook(final Book book) {
		books.add(book);
		byTitle.put(book.getShortTitle(), book);

		if (book.isReferenced())
		for (final String keyword : book.getKeywords()) {

			List<Book> list = byKeyword.get(keyword);
			if (list == null) {
				list = new ArrayList<Book>();
				byKeyword.put(keyword, list);
			}

			list.add(book);
		}
	}

	public int size() { return books.size(); }

	public Iterator<Book> iterator() {
		Collections.sort(books);
		return books.iterator();
	}
}
